// ivc2-cpu.h - Hand-written code for the Toshiba IVC2 coprocessor. -*- C++ -*-

// Copyright (C) 2009 Red Hat.
// This file is part of SID and is licensed under the GPL.
// See the file COPYING.SID for conditions for redistribution.

// This file is included in the middle of the cpu class struct.

public:
      DI ivc2_cdadd3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cdcastuw (PCADDR &pc, DI crqc);
      DI ivc2_cdcastw (PCADDR &pc, DI crqc);
      DI ivc2_cdclipi3 (PCADDR &pc, DI crpc, SI imm6_6);
      DI ivc2_cdclipiu3 (PCADDR &pc, DI crpc, SI imm6_6);
      DI ivc2_cdmovi (PCADDR &pc, SI imm8_4);
      DI ivc2_cdmovi16 (PCADDR &pc, SI imm16);
      DI ivc2_cdmoviu (PCADDR &pc, SI imm8_4);
      DI ivc2_cdmoviu16 (PCADDR &pc, SI imm16);
      DI ivc2_cdsll3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cdslli3 (PCADDR &pc, DI crpc, SI imm6_6);
      DI ivc2_cdsra3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cdsrai3 (PCADDR &pc, DI crpc, SI imm6_6);
      DI ivc2_cdsrl3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cdsrli3 (PCADDR &pc, DI crpc, SI imm6_6);
      DI ivc2_cdsub3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpabs3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpabs3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpabsu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpabsz_b (PCADDR &pc, DI crqc);
      DI ivc2_cpabsz_h (PCADDR &pc, DI crqc);
      DI ivc2_cpabsz_w (PCADDR &pc, DI crqc);
      DI ivc2_cpadd3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpadd3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpadd3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpaddsr3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpaddsr3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpaddsr3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpaddsru3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpand3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpave3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpave3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpave3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpaveu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpbcast_b (PCADDR &pc, DI crqc);
      DI ivc2_cpbcast_h (PCADDR &pc, DI crqc);
      DI ivc2_cpbcast_w (PCADDR &pc, DI crqc);
      DI ivc2_cpcastb_h (PCADDR &pc, DI crqc);
      DI ivc2_cpcastb_w (PCADDR &pc, DI crqc);
      DI ivc2_cpcasth_w (PCADDR &pc, DI crqc);
      DI ivc2_cpcastub_h (PCADDR &pc, DI crqc);
      DI ivc2_cpcastub_w (PCADDR &pc, DI crqc);
      DI ivc2_cpcastuh_w (PCADDR &pc, DI crqc);
      DI ivc2_cpccadd_b (PCADDR &pc, DI crqc);
      DI ivc2_cpclipi3_w (PCADDR &pc, DI crpc, SI imm5_7);
      DI ivc2_cpclipiu3_w (PCADDR &pc, DI crpc, SI imm5_7);
      DI ivc2_cpextl_b (PCADDR &pc, DI crqc);
      DI ivc2_cpextl_h (PCADDR &pc, DI crqc);
      DI ivc2_cpextladd3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextladdu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextlsub3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextlsubu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextlu_b (PCADDR &pc, DI crqc);
      DI ivc2_cpextlu_h (PCADDR &pc, DI crqc);
      DI ivc2_cpextu_b (PCADDR &pc, DI crqc);
      DI ivc2_cpextu_h (PCADDR &pc, DI crqc);
      DI ivc2_cpextuadd3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextuaddu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextusub3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextusubu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpextuu_b (PCADDR &pc, DI crqc);
      DI ivc2_cpextuu_h (PCADDR &pc, DI crqc);
      DI ivc2_cpfsftbi (PCADDR &pc, DI crqc, DI crpc, SI imm3_4);
      DI ivc2_cpfsftbs0 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpfsftbs1 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cphadd_b (PCADDR &pc, DI crqc);
      DI ivc2_cphadd_h (PCADDR &pc, DI crqc);
      DI ivc2_cphadd_w (PCADDR &pc, DI crqc);
      DI ivc2_cphaddu_b (PCADDR &pc, DI crqc);
      DI ivc2_cpldz_h (PCADDR &pc, DI crqc);
      DI ivc2_cpldz_w (PCADDR &pc, DI crqc);
      DI ivc2_cpmax3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmax3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmax3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmaxu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmaxu3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmin3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmin3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmin3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpminu3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpminu3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpmov (PCADDR &pc, DI crqc);
      DI ivc2_cpmova0_b (PCADDR &pc);
      DI ivc2_cpmova1_b (PCADDR &pc);
      DI ivc2_cpmovfrcc (PCADDR &pc);
      DI ivc2_cpmovfrcsar0 (PCADDR &pc);
      DI ivc2_cpmovfrcsar1 (PCADDR &pc);
      DI ivc2_cpmovhla0_w (PCADDR &pc);
      DI ivc2_cpmovhla1_w (PCADDR &pc);
      DI ivc2_cpmovhua0_w (PCADDR &pc);
      DI ivc2_cpmovhua1_w (PCADDR &pc);
      DI ivc2_cpmovi_b (PCADDR &pc, SI imm8_4);
      DI ivc2_cpmovi_h (PCADDR &pc, SI imm8_4);
      DI ivc2_cpmovi_h16 (PCADDR &pc, SI imm16p0);
      DI ivc2_cpmovi_w (PCADDR &pc, SI imm8_4);
      DI ivc2_cpmovi_w16 (PCADDR &pc, SI imm16p0);
      DI ivc2_cpmoviu_h (PCADDR &pc, SI imm8_4);
      DI ivc2_cpmoviu_w (PCADDR &pc, SI imm8_4);
      DI ivc2_cpmoviu_w16 (PCADDR &pc, SI imm16p0);
      DI ivc2_cpmovla0_h (PCADDR &pc);
      DI ivc2_cpmovla1_h (PCADDR &pc);
      DI ivc2_cpmovlla0_w (PCADDR &pc);
      DI ivc2_cpmovlla1_w (PCADDR &pc);
      DI ivc2_cpmovlua0_w (PCADDR &pc);
      DI ivc2_cpmovlua1_w (PCADDR &pc);
      DI ivc2_cpmovua0_h (PCADDR &pc);
      DI ivc2_cpmovua1_h (PCADDR &pc);
      DI ivc2_cpmovula0_w (PCADDR &pc);
      DI ivc2_cpmovula1_w (PCADDR &pc);
      DI ivc2_cpmovuua0_w (PCADDR &pc);
      DI ivc2_cpmovuua1_w (PCADDR &pc);
      DI ivc2_cpnor3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpnorm_h (PCADDR &pc, DI crqc);
      DI ivc2_cpnorm_w (PCADDR &pc, DI crqc);
      DI ivc2_cpor3 (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cppack_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cppack_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cppacka0_b (PCADDR &pc);
      DI ivc2_cppacka0u_b (PCADDR &pc);
      DI ivc2_cppacka1_b (PCADDR &pc);
      DI ivc2_cppacka1u_b (PCADDR &pc);
      DI ivc2_cppackla0_h (PCADDR &pc);
      DI ivc2_cppackla0_w (PCADDR &pc);
      DI ivc2_cppackla1_h (PCADDR &pc);
      DI ivc2_cppackla1_w (PCADDR &pc);
      DI ivc2_cppacku_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cppackua0_h (PCADDR &pc);
      DI ivc2_cppackua0_w (PCADDR &pc);
      DI ivc2_cppackua1_h (PCADDR &pc);
      DI ivc2_cppackua1_w (PCADDR &pc);
      DI ivc2_cpsadd3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsadd3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsel (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsla3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsla3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpslai3_h (PCADDR &pc, DI crpc, SI imm4_8);
      DI ivc2_cpslai3_w (PCADDR &pc, DI crpc, SI imm5_7);
      DI ivc2_cpsll3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsll3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsll3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpslli3_b (PCADDR &pc, DI crpc, SI imm3_9);
      DI ivc2_cpslli3_h (PCADDR &pc, DI crpc, SI imm4_8);
      DI ivc2_cpslli3_w (PCADDR &pc, DI crpc, SI imm5_7);
      DI ivc2_cpsra3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsra3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsra3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsrai3_b (PCADDR &pc, DI crpc, SI imm3_9);
      DI ivc2_cpsrai3_h (PCADDR &pc, DI crpc, SI imm4_8);
      DI ivc2_cpsrai3_w (PCADDR &pc, DI crpc, SI imm5_7);
      DI ivc2_cpsrl3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsrl3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsrl3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsrli3_b (PCADDR &pc, DI crpc, SI imm3_9);
      DI ivc2_cpsrli3_h (PCADDR &pc, DI crpc, SI imm4_8);
      DI ivc2_cpsrli3_w (PCADDR &pc, DI crpc, SI imm5_7);
      DI ivc2_cpssll3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssll3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssll3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssra3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssra3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssra3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssrl3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssrl3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssrl3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssub3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpssub3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsub3_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsub3_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpsub3_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpunpackl_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpunpackl_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpunpackl_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpunpacku_b (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpunpacku_h (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpunpacku_w (PCADDR &pc, DI crqc, DI crpc);
      DI ivc2_cpxor3 (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_c0nop (PCADDR &pc);
      void ivc2_c1nop (PCADDR &pc);
      void ivc2_cpabsa0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpabsa0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpabsa1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpabsa1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpabsla0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpabsla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpabsua0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpabsua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpaccpa0 (PCADDR &pc);
      void ivc2_cpaccpa1 (PCADDR &pc);
      void ivc2_cpacmpeq_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpeq_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpeq_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpge_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpge_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpge_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpgeu_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpgeu_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpgt_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpgt_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpgt_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpgtu_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpgtu_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpne_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpne_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacmpne_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpacsuma0 (PCADDR &pc);
      void ivc2_cpacsuma1 (PCADDR &pc);
      void ivc2_cpacswp (PCADDR &pc);
      void ivc2_cpadda0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpadda0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpadda1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpadda1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpaddaca0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpaddaca0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpaddaca1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpaddaca1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpaddacla0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpaddacla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpaddacua0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpaddacua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpaddla0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpaddla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpaddua0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpaddua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpamadia1_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpamadia1u_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpamadila1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpamadiua1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpamulia1_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpamulia1u_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpamulila1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpamuliua1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpcmpeq_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpeq_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpeq_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpeqz_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpge_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpge_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpge_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpgeu_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpgeu_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpgt_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpgt_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpgt_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpgtu_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpgtu_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpne_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpne_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpcmpne_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpfaca0s0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfaca0s0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfaca0s1_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfaca0s1u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfacla0s0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfacla0s1_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfacua0s0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfacua0s1_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfmadia1_b (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmadia1s0_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmadia1s0u_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmadia1s1_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmadia1s1u_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmadia1u_b (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmadila1_h (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmadila1s0_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmadila1s1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmadiua1_h (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmadiua1s0_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmadiua1s1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmulia1_b (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmulia1s0_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmulia1s0u_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmulia1s1_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmulia1s1u_b (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmulia1u_b (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmulila1_h (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmulila1s0_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmulila1s1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmuliua1_h (PCADDR &pc, DI crqp, DI crpp, SI imm3, SI imm8);
      void ivc2_cpfmuliua1s0_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfmuliua1s1_h (PCADDR &pc, DI crqp, DI crpp, SI imm8_0);
      void ivc2_cpfsftba0s0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfsftba0s0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfsftba0s1_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfsftba0s1u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfsftbla0s0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfsftbla0s1_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfsftbua0s0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpfsftbua0s1_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpmada1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmada1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmadla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmadla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmadla1u_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmadua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmadua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmadua1u_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmovtocc (PCADDR &pc, DI crqc);
      void ivc2_cpmovtocsar0 (PCADDR &pc, DI crqc);
      void ivc2_cpmovtocsar1 (PCADDR &pc, DI crqc);
      void ivc2_cpmsbla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmsbla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmsbla1u_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmsbua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmsbua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmsbua1u_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmula1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmula1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulla1u_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulslla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulslla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulslua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulslua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpmulua1u_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpeq_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpeq_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpeq_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpge_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpge_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpge_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpgeu_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpgeu_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpgt_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpgt_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpgt_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpgtu_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpgtu_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpne_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpne_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpocmpne_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsada0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsada0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsada1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsada1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsadla0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsadla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsadua0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsadua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpseta0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpseta1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsetla0_w (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsetla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsetua0_w (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsetua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpslla0 (PCADDR &pc, DI crqp);
      void ivc2_cpslla1 (PCADDR &pc, DI crqc);
      void ivc2_cpsllia0 (PCADDR &pc, SI imm5_23);
      void ivc2_cpsllia1 (PCADDR &pc, SI imm5_7);
      void ivc2_cpsmadla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmadla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmadslla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmadslla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmadslua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmadslua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmadua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmadua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbslla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbslla1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbslua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbslua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsmsbua1_w (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsraa0 (PCADDR &pc, DI crqp);
      void ivc2_cpsraa1 (PCADDR &pc, DI crqc);
      void ivc2_cpsraia0 (PCADDR &pc, SI imm5_23);
      void ivc2_cpsraia1 (PCADDR &pc, SI imm5_7);
      void ivc2_cpsrla0 (PCADDR &pc, DI crqp);
      void ivc2_cpsrla1 (PCADDR &pc, DI crqc);
      void ivc2_cpsrlia0 (PCADDR &pc, SI imm5_23);
      void ivc2_cpsrlia1 (PCADDR &pc, SI imm5_7);
      void ivc2_cpssda1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpssda1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpssqa1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpssqa1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsuba0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsuba0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsuba1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsuba1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsubaca0_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsubaca0u_b (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsubaca1_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsubaca1u_b (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsubacla0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsubacla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsubacua0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsubacua1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsubla0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsubla1_h (PCADDR &pc, DI crqc, DI crpc);
      void ivc2_cpsubua0_h (PCADDR &pc, DI crqp, DI crpp);
      void ivc2_cpsubua1_h (PCADDR &pc, DI crqc, DI crpc);
