/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

/* Global data structures. */

/* There is actually no inherent limit on the number of winning and losing */
/* conditions, but scenarios usually only need a couple. */

#define NUMCONDS 10

/* Not many types of conditions (probably could think of a few more). */

#define TERRITORY 0
#define UNITCOUNT 1
#define RESOURCECOUNT 2
#define POSSESSION 3

/* Win/lose conditions can take several different forms.  Some of these */
/* slots could be glommed into a union, but so what... */

typedef struct a_condition {
    bool win;                   /* is this a condition of winning or losing? */
    int type;                   /* based on units, resources, or location? */
    int starttime;		/* first turn to check on condition */
    int endtime;                /* last turn to check on condition */
    int sidesn;                 /* side number to which this cond applies */
    int units[MAXUTYPES];       /* numbers for each type of unit */
    int resources[MAXRTYPES];   /* numbers for each type of resource */
    int x, y;                   /* a location */
    int n;                      /* a vanilla value */
} Condition;

/* Definition of structure containing all global variables. */

typedef struct a_global {
    int time;			/* the current turn */
    int endtime;                /* the last turn of the game */
    bool setproduct;            /* true if production changes allowed */
    bool leavemap;              /* true if units can leave the map */
    int numconds;               /* number of conditions... */
    Condition winlose[NUMCONDS];  /* and space for the conditions themselves */
    long giventime;		/* length of the game is seconds for chess clock */
    long timeout;		/* how long before a turn times out */
    long elapsedtime;		/* Elapsed time for current turn */
} Global;

extern Global global;

/* external declarations. */

/* attack */
extern char killbuf[];
extern bool enough_ammo(Unit *atker, Unit *other);
extern void capture_unit(Unit *unit, Unit *pris);
extern bool attack(Unit *atker, Unit *other);

/* draw */
extern void show_all_sides(Side *side);
extern void show_turn_clock(Side *side, char *clockbuf);
extern void show_side_clock(Side *side, char *clockbuf);
extern void show_time(Side *side);
extern void show_mode(Side *side);
extern void update_state(Side *side, int u);
extern void show_state(Side *side);
extern void xform(Side *side, int x, int y, int *sxp, int *syp);
extern int unwrap(Side *side, int x, int y);
extern void show_world(Side *side);
extern void w_xform(Side *side, int x, int y, int *sxp, int *syp);
extern void deform(Side *side, int sx, int sy, int *xp, int *yp);
extern void draw_hex(Side *side, int x, int y, bool flushit);
extern void draw_cursor(Side *side);
extern void erase_cursor(Side *side);
extern void draw_blast(Unit *unit, Side *es, int hit);
extern void show_map(Side *side);
extern void recenter(Side *side, int x, int y);
extern bool in_middle(Side *side, int x, int y);
extern void put_on_screen(Side *side, int x, int y);
extern void show_status(Side *side, Unit *unit);
extern void show_hp(Side *side, Unit *unit);
extern void show_product(Side *side, Unit *unit);
extern void show_resources(Side *side, Unit *unit);
extern void show_intimate_details(Side *side, Unit *unit);
extern void show_info(Side *side);

/* ginit */
extern bool active_display(Side *side);
extern void init_displays1(int argc, char *argv[]);

/* init */
extern bool periodmade, mapmade, globalsmade, sidesmade, unitsmade;
extern bool populations;
extern void init_supply(Unit *unit);
extern void init_game();
extern bool saved_game();

/* input */
extern int ask_unit_type(Side *side, short *possibles);
extern void request_new_product(Unit *unit);

/* move */
extern Side *curside;
extern void cancel_build(Unit *unit);
extern void wake_neighbors(Unit *unit);
extern void set_side_movunit(Side *side);
extern bool move_to_next(Unit *unit, int dx, int dy, bool mustgo, bool atk);
extern void move_mode(Side *side);
extern void survey_mode(Side *side);
extern void movement_phase();
extern void make_current(Side *side, Unit *unit);
extern bool retreat_unit(Unit *unit);
extern void move_survey(Side *side, int nx, int ny);

/* order */
extern char *dirnames[];
extern int orderargs[];
extern wake_unit(Unit *unit, bool wakeocc, int reason, Unit *other);
extern void cache_awake(Side *side);
extern char *order_desig(Order *orders);
extern void copy_orders(Order *dst, Order *src);
extern void finish_teach(Side *side);
extern void order_sentry(Unit *unit, int n);
extern void cache_sentry(Side *side, int n);
extern void order_moveto(Unit *unit, int x, int y);
extern void cache_moveto(Side *side, int x, int y);
extern void order_return(Unit *unit, int n);
extern void cache_return(Side *side, int n);
extern void order_follow(Unit *unit, Unit *leader, int n);
extern void cache_follow(Side *side, Unit *leader, int n);
extern void order_edge(Unit *unit, int d, int ccw, int n);
extern void cache_edge(Side *side, int d, int ccw, int n);
extern void cache_patrol(Side *side, int x0, int y0, int x1, int y1, int n);
extern void order_patrol(Unit *unit, int x0, int y0, int x1, int y1, int n);
extern void order_embark(Unit *unit, int n);
extern void cache_embark(Side *side, int n);
extern void order_movedir(Unit *unit, int dir, int n);
extern void order_movetounit(Unit *unit, Unit *dest, int n);
extern void cache_movetounit(Side *side, Unit *dest, int n);
extern void order_fill(Unit *unit, int n);
extern void cache_fill(Side *side, int n);
extern void order_movetotransport(Unit *unit, int n);
extern void cache_movetotransport(Side *side, int n);
extern void cache_disembark(Side *side, int n);
extern void cache_auto(Side *side);

/* output */
extern int wline;
extern void notify_all(const char *control, ... );
extern void notify(Side *side, const char *control, ... );
extern void cmd_error(Side *side, const char *control, ... );
extern void init_wprintf(Side *side, char *fname);
extern void wprintf(Side *side, char *control, ...);
extern void finish_wprintf();

/* phases */
extern void spy_phase();
extern void disaster_phase();
extern void build_phase();
extern int transfer_supply(Unit *from, Unit *to, int r, int amount);
extern void try_transfer(Unit *from, Unit *to, int r);
extern void supply_phase();
extern void exhaust_supply(Unit *unit);
extern void consumption_phase();

/* sergeant */
int search_path(Unit *unit, int maxdist, bool (*pred)());

/* xconq */
extern void close_displays();
extern void exit_xconq();
extern void side_loses(Side *side, Side *victor);
extern void resign_game(Side *side, Side *side2);
extern void time_up(Side *side);

