/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* Copyright (c) 1995 Michael J. Peters */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

/* This file concentrates on the more textual parts of the interface, mainly */
/* the windows dedicated to messages and the like. */

#include "config.h"
#include "misc.h"
#include "period.h"
#include "side.h"
#include "unit.h"
#include "map.h"
#include "X11.h"
#include "Motif.h"
#include "global.h"

char tmpnbuf[BUFSIZE];          /* tmp buf for notices only. */

/* 
 * Main message-sending routine - does its own formatting and spits out to
 * the given side.
 */

void write_msg(Side *side, const char *control, va_list args) {

    if (active_display(side)) {

	vsprintf(tmpnbuf, control, args);

	if (islower(tmpnbuf[0])) tmpnbuf[0] = toupper(tmpnbuf[0]);

	write_msg_text(side, "%d: %s\n", global.time, tmpnbuf);
    }
}

/* 
 * Write message to a side
 */

void notify(Side *side, const char *control, ...) {

    va_list args;

    va_start (args, control);
	write_msg(side, control, args);
    va_end (args);
}

/* Generic command error routine - beeps display etc. */

void cmd_error(Side *side, const char *control, ... ) {

    va_list args;

    va_start (args, control);
        write_msg(side, control, args);
    va_end (args);

    if (active_display(side) && humanside(side) &&
        (side->curunit == NULL || !side->curunit->orders.morder))
       beep(side);
}

/* Send a message to everybody who's got a screen. */

void notify_all(const char *control, ... ) {

    va_list args;

    Side *side;

    va_start (args, control);
        for_all_sides(side) write_msg(side, control, args);
    va_end (args);
}

/* Variables for the "window printf" utilities. */

bool wprintmode;		/* true when printing is going into a file */
int wline;			/* current position of output */
char wbuf[BUFSIZE];		/* accumulated line of text */
FILE *wfp;			/* file pointer for wprintf */

/* Init our counters or open a file. */

void init_wprintf(Side *side, char *fname) {

    wline = 0;
    if (fname != NULL) {
        wprintmode = TRUE;
        wfp = fopen(fname, "w");
        if (wfp == NULL)
            notify(side, "Warning: open failed.");
    } else
        wprintmode = FALSE;
}

/* Make like printf, but to the help window.  This is pretty crude - has an */
/* automatic newlining (mis)feature, and doesn't do anything about long */
/* lines, but it's good enough. */

void wprintf(Side *side, char *control, ...) {

    va_list args;

    if (active_display(side)) {
        va_start (args, control);
            vsprintf(wbuf, control, args);
        va_end (args);

        if (wprintmode && wfp != NULL)
            fprintf(wfp, "%s\n", wbuf);
        else {
            write_help_text(side, "%s\n", wbuf);
            wline++;
        }
    }
}

/* If we were actually printing to a file, close it down. */

void finish_wprintf() {

    if (wprintmode && wfp != NULL) fclose(wfp);
}
