/* Definitions for the X11 interface to Xconq.
   Copyright (C) 1987-1989, 1991-1998 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

/* Default color of text and icons - 0 is for white on black, 1 is for
   black on white.  Should be set appropriately for the most common
   monochrome display (color displays always do white on black).  This
   is also settable by the player, so the default is just for
   convenience of the majority. */

#define BLACKONWHITE 1

/* The default fonts can be altered by users, so these are just hints. */

#define TEXTFONT "fixed"

/* Some X11 servers die if too much is written between output flushes. */

/* #define STUPIDFLUSH */

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>

#include <math.h>

#include "imf.h"
#include "ximf.h"
#include "ui.h"
#include "print.h"

enum grayshade {
  black,
  gray,
  darkgray,
  numgrays
};

/* Drawing techniques that may be used. */

enum whattouse {
  dontdraw,
  useblocks,
  usepictures,
  usepolygons
};
