#!/bin/sh

CXXTOOLS=cxxtools-1.4.5.2
TNTNET=tntnet-1.6.0.5
TNTREADER=tntzenoreader-1.0.1
SRCDIR=`echo $0|sed 's/build.sh//'`

build() {

  TOOL=$1
  NAME=$2
  CONFIGFLAGS=$3
  TGZ=$SRCDIR/$NAME.tar.gz

  if [ ! $TGZ ]
    then
      echo "source $TGZ nicht gefunden"
      exit 1
    fi

  echo "entpacke $TGZ"
  tar xzf $TGZ && cd $NAME || {
    echo "Fehler beim Auspacken der Sourcen zu $TOOL"
    exit 1
  }

  echo "baue $TOOL"
  ./configure $CONFIGFLAGS && make all || {
    echo "Fehler beim bauen von $TOOL"
    exit 1
  }

  echo "installiere $TOOL"
  sudo make install || {
    echo "Fehler beim installieren von $TOOL"
    exit 1
  }

  if [ -f /sbin/ldconfig ]
    then sudo /sbin/ldconfig
  elif [ -f /usr/sbin/ldconfig ]
    then sudo /usr/sbin/ldconfig
  elif [ -f /bin/ldconfig ]
    then sudo /bin/ldconfig
  elif [ -f /usr/bin/ldconfig ]
    then sudo /usr/bin/ldconfig
  else
    sudo ldconfig
  fi

  cd -
}

build_cxxtools() {
  build cxxtools $CXXTOOLS
}

build_tntnet() {
  build tntnet $TNTNET '--without-ssl --without-demos'
}

build_tntreader() {
  build tntreader $TNTREADER
}

if [ "$1" ]; then
  while [ "$1" ]
    do
      build_$1
      shift
    done
else
  build_cxxtools
  build_tntnet
  build_tntreader
fi
